---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：24-Master Overview（マスター概要）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **DeployMessagesのMasterStateResponseフィールド一覧**：DeployMessages.scalaの直接読み込みは行っていないため推定

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/deploy/master/ui/MasterPage.scala`（391行）
- E-02: `core/src/main/scala/org/apache/spark/deploy/master/ui/MasterWebUI.scala`（135行）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLはMasterWebUIのルート `/` | E-01 (33行目: `WebUIPage("")`), E-02 (63行目: `attachPage(masterPage)`) | ○ |
| C-02 | getMasterStateでRPCによりクラスタ状態を取得 | E-01 (38-40行目: `master.askSync[MasterStateResponse](RequestMasterState)`) | ○ |
| C-03 | JSON APIを提供（/json/パス） | E-01 (42-49行目: `renderJson`, 36行目: `jsonFieldPattern`) | ○ |
| C-04 | Kill操作はkillEnabledとcheckModifyPermissionsで制御 | E-01 (66-67行目), E-02 (47行目, 66-71行目) | ○ |
| C-05 | アプリケーションKillはremoveApplication(KILLED)を呼出 | E-01 (53-54行目) | ○ |
| C-06 | ドライバーKillはRequestKillDriverを送信 | E-01 (61行目) | ○ |
| C-07 | Kill時にJavaScript確認ダイアログを表示 | E-01 (303-305行目, 354-356行目: `window.confirm`) | ○ |
| C-08 | Kill時に100msのThread.sleepが挟まれる | E-01 (74行目: `Thread.sleep(100)`) | ○ |
| C-09 | ワーカーテーブルにResources列はリソース保持ワーカー存在時のみ表示 | E-01 (104-109行目: `showResourceColumn`) | ○ |
| C-10 | アクティブアプリは開始時刻の降順ソート | E-01 (116行目: `state.activeApps.sortBy(_.startTime).reverse`) | ○ |
| C-11 | 完了アプリは終了時刻の降順ソート | E-01 (118行目: `state.completedApps.sortBy(_.endTime).reverse`) | ○ |
| C-12 | ドライバーセクションは存在時のみ表示 | E-01 (135行目: `def hasDrivers: Boolean = activeDrivers.length > 0 || completedDrivers.length > 0`) | ○ |
| C-13 | ワーカーはALIVEの場合Worker UIへのリンク付き | E-01 (278行目: `if (worker.isAlive())`) | ○ |
| C-14 | アプリケーションIDはApplication Detail画面へのリンク付き | E-01 (314行目: `<a href={"app/?appId=" + app.id}>`) | ○ |
| C-15 | アプリケーション名はUI URLありかつ未完了の場合リンク付き | E-01 (319-324行目) | ○ |
| C-16 | ページタイトルはspark.master.ui.title設定で変更可能 | E-01 (35行目: `parent.master.conf.get(MASTER_UI_TITLE)`), (271行目) | ○ |
| C-17 | 基本情報にURL, REST URL, Workers, Cores, Memory, Resources, Applications, Drivers, Statusを表示 | E-01 (141-177行目) | ○ |
| C-18 | EnvironmentリンクとLogリンクが基本情報に含まれる | E-01 (175-176行目) | ○ |
| C-19 | Decommission機能は/workers/kill REST APIとして存在 | E-02 (72-95行目) | ○ |
| C-20 | reverseProxy設定時はリンクがプロキシ経由パスになる | E-01 (279行目: `UIUtils.makeHref(parent.master.reverseProxy...)`) | ○ |
| C-21 | 画面遷移先にApplication Detail, Master Log, Master Environmentがある | E-05 (100-102行目) | ○ |
| C-22 | MasterStateResponseのフィールド一覧 | **根拠なし**（DeployMessages.scalaを直接読んでいない） | △ |

## 4) 不足情報（Unknown / Missing）
- C-22: MasterStateResponseの正確なフィールド一覧はDeployMessages.scalaの直接確認が必要。ただしMasterPage.scalaの使用箇所からフィールドは推定可能
  - 候補：DeployMessages.scala / Master.scala

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - MasterPage.scalaの直接読み込みにより大部分の主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] MasterStateResponseのフィールドが正確か確認（DeployMessages.scalaを参照）
- [ ] Kill操作の権限チェックフローが正しいか確認
- [ ] JSON APIの応答形式が正確か確認
